// CPhoneme.cp
// CPhoneme.h
// ----------------------------------------------------------------------------------
// The user dictionary class.
//
// This dictionary is a dictionary that is created by users.
//
// Note: This file is proprietary and confidential to Art Pollard
//	and Lextek Internation.  
// Copyright 1994 Art Pollard / LexTek International
//
//
// ----------------------------------------------------------------------------------
// History:
// 		Art Pollard			June 94
//			Original
//		Clark Goble			08/13/94
//			Checked it over and made a few modifications as part of the
//			C++ conversion.
// ----------------------------------------------------------------------------------


#ifndef _CPHONEME_
#define _CPHONEME_


#include <string.h>
#include "UParser.h"
#include "USound.h"
#include "UPhnMch.h"
#include "CMnDct.h"


class CPhoneme : USound, UParser {
public:
	
	void First(CMainDict *Dict, short Initial_Phoneme, char *Word);
	short  Next(CMainDict *Dict, char *Word);
	void CreateFilter(char *Word);
	short  PhoneticTestWord(char *Word);
	//		      void AddUserFeatures(USER *UserFeatures);
	short  FirstSuggestion(CMainDict *Dict, char *PhonPattern, char *Word,
			CallBackProc CallBack);
	short  NextSuggestion(CMainDict *Dict, char *PhonPattern, char *Word,
			CallBackProc CallBack);
	
	CPhoneme();
	~CPhoneme();

	
	private:
	
	char 	*CurrentInitialPhoneme;
	short 	InitialPhonemeLength;
	char 	PossibleSuggestion[MAXWORDLENGTH];

};

#endif


